/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: DMAStateDlg.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: 29.10.09 12:32 $
    $Revision: 436 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    DMA State Get/Set Test dialog
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
      1        29.10.2009  RM       created
 
**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file DMAStateDlg.h
///   DMA State Get/Set Test dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// DMA State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CDMAStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CDMAStateDlg)

public:
	CDMAStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CDMAStateDlg();

// Dialog Data
	enum { IDD = IDD_DMASTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  unsigned long   m_ulSetTimeout;   //!< Timeout when calling Set Bus State
  CComboBox       m_cNewStateCtrl;  //!< Set DMA State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
